<?php
declare(strict_types=1);

/**
 * WorkspacesApi.
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\WorkspacesApi;


/**
 * GetWorkspaceFileOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetWorkspaceFileOptions
{
    /**
      * $is_download When set to **true**, the Content-Disposition header is set in the response. The value of the header provides the filename of the file. Default is **false**.
      * @var ?string
      */
    protected ?string $is_download = null;

    /**
     * Gets is_download
     *
     * @return ?string
     */
    public function getIsDownload(): ?string
    {
        return $this->is_download;
    }

    /**
     * Sets is_download
     * @param ?string $is_download When set to **true**, the Content-Disposition header is set in the response. The value of the header provides the filename of the file. Default is **false**.
     *
     * @return self
     */
    public function setIsDownload(?string $is_download): self
    {
        $this->is_download = $is_download;
        return $this;
    }
    /**
      * $pdf_version When set to **true** the file returned as a PDF.
      * @var ?string
      */
    protected ?string $pdf_version = null;

    /**
     * Gets pdf_version
     *
     * @return ?string
     */
    public function getPdfVersion(): ?string
    {
        return $this->pdf_version;
    }

    /**
     * Sets pdf_version
     * @param ?string $pdf_version When set to **true** the file returned as a PDF.
     *
     * @return self
     */
    public function setPdfVersion(?string $pdf_version): self
    {
        $this->pdf_version = $pdf_version;
        return $this;
    }
}


/**
 * ListWorkspaceFilePagesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListWorkspaceFilePagesOptions
{
    /**
      * $count The maximum number of results to be returned by this request.
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count The maximum number of results to be returned by this request.
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $dpi Number of dots per inch for the resulting image. The default if not used is 94. The range is 1-310.
      * @var ?string
      */
    protected ?string $dpi = null;

    /**
     * Gets dpi
     *
     * @return ?string
     */
    public function getDpi(): ?string
    {
        return $this->dpi;
    }

    /**
     * Sets dpi
     * @param ?string $dpi Number of dots per inch for the resulting image. The default if not used is 94. The range is 1-310.
     *
     * @return self
     */
    public function setDpi(?string $dpi): self
    {
        $this->dpi = $dpi;
        return $this;
    }
    /**
      * $max_height Sets the maximum height (in pixels) of the returned image.
      * @var ?string
      */
    protected ?string $max_height = null;

    /**
     * Gets max_height
     *
     * @return ?string
     */
    public function getMaxHeight(): ?string
    {
        return $this->max_height;
    }

    /**
     * Sets max_height
     * @param ?string $max_height Sets the maximum height (in pixels) of the returned image.
     *
     * @return self
     */
    public function setMaxHeight(?string $max_height): self
    {
        $this->max_height = $max_height;
        return $this;
    }
    /**
      * $max_width Sets the maximum width (in pixels) of the returned image.
      * @var ?string
      */
    protected ?string $max_width = null;

    /**
     * Gets max_width
     *
     * @return ?string
     */
    public function getMaxWidth(): ?string
    {
        return $this->max_width;
    }

    /**
     * Sets max_width
     * @param ?string $max_width Sets the maximum width (in pixels) of the returned image.
     *
     * @return self
     */
    public function setMaxWidth(?string $max_width): self
    {
        $this->max_width = $max_width;
        return $this;
    }
    /**
      * $start_position The position within the total result set from which to start returning values. The value **thumbnail** may be used to return the page image.
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position The position within the total result set from which to start returning values. The value **thumbnail** may be used to return the page image.
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
}


/**
 * ListWorkspaceFolderItemsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListWorkspaceFolderItemsOptions
{
    /**
      * $count The maximum number of results to be returned by this request.
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count The maximum number of results to be returned by this request.
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $include_files When set to **true**, file information is returned in the response along with folder information. The default is **false**.
      * @var ?string
      */
    protected ?string $include_files = null;

    /**
     * Gets include_files
     *
     * @return ?string
     */
    public function getIncludeFiles(): ?string
    {
        return $this->include_files;
    }

    /**
     * Sets include_files
     * @param ?string $include_files When set to **true**, file information is returned in the response along with folder information. The default is **false**.
     *
     * @return self
     */
    public function setIncludeFiles(?string $include_files): self
    {
        $this->include_files = $include_files;
        return $this;
    }
    /**
      * $include_sub_folders When set to **true**, information about the sub-folders of the current folder is returned. The default is **false**.
      * @var ?string
      */
    protected ?string $include_sub_folders = null;

    /**
     * Gets include_sub_folders
     *
     * @return ?string
     */
    public function getIncludeSubFolders(): ?string
    {
        return $this->include_sub_folders;
    }

    /**
     * Sets include_sub_folders
     * @param ?string $include_sub_folders When set to **true**, information about the sub-folders of the current folder is returned. The default is **false**.
     *
     * @return self
     */
    public function setIncludeSubFolders(?string $include_sub_folders): self
    {
        $this->include_sub_folders = $include_sub_folders;
        return $this;
    }
    /**
      * $include_thumbnails When set to **true**, thumbnails are returned as part of the response.  The default is **false**.
      * @var ?string
      */
    protected ?string $include_thumbnails = null;

    /**
     * Gets include_thumbnails
     *
     * @return ?string
     */
    public function getIncludeThumbnails(): ?string
    {
        return $this->include_thumbnails;
    }

    /**
     * Sets include_thumbnails
     * @param ?string $include_thumbnails When set to **true**, thumbnails are returned as part of the response.  The default is **false**.
     *
     * @return self
     */
    public function setIncludeThumbnails(?string $include_thumbnails): self
    {
        $this->include_thumbnails = $include_thumbnails;
        return $this;
    }
    /**
      * $include_user_detail Set to **true** to return extended details about the user. The default is **false**.
      * @var ?string
      */
    protected ?string $include_user_detail = null;

    /**
     * Gets include_user_detail
     *
     * @return ?string
     */
    public function getIncludeUserDetail(): ?string
    {
        return $this->include_user_detail;
    }

    /**
     * Sets include_user_detail
     * @param ?string $include_user_detail Set to **true** to return extended details about the user. The default is **false**.
     *
     * @return self
     */
    public function setIncludeUserDetail(?string $include_user_detail): self
    {
        $this->include_user_detail = $include_user_detail;
        return $this;
    }
    /**
      * $start_position The position within the total result set from which to start returning values.
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position The position within the total result set from which to start returning values.
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $workspace_user_id If set, then the results are filtered to those associated with the specified userId.
      * @var ?string
      */
    protected ?string $workspace_user_id = null;

    /**
     * Gets workspace_user_id
     *
     * @return ?string
     */
    public function getWorkspaceUserId(): ?string
    {
        return $this->workspace_user_id;
    }

    /**
     * Sets workspace_user_id
     * @param ?string $workspace_user_id If set, then the results are filtered to those associated with the specified userId.
     *
     * @return self
     */
    public function setWorkspaceUserId(?string $workspace_user_id): self
    {
        $this->workspace_user_id = $workspace_user_id;
        return $this;
    }
}



namespace DocuSign\eSign\Api;

use DocuSign\eSign\Client\ApiClient;
use DocuSign\eSign\Client\ApiException;
use DocuSign\eSign\Configuration;
use DocuSign\eSign\ObjectSerializer;

/**
 * WorkspacesApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class WorkspacesApi
{
    /**
     * API Client
     *
     * @var ApiClient instance of the ApiClient
     */
    protected ApiClient $apiClient;

    /**
     * Constructor
     *
     * @param ApiClient|null $apiClient The api client to use
     *
     * @return void
     */
    public function __construct(ApiClient $apiClient = null)
    {
        $this->apiClient = $apiClient ?? new ApiClient();
    }

    /**
     * Get API client
     *
     * @return ApiClient get the API client
     */
    public function getApiClient(): ApiClient
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param ApiClient $apiClient set the API client
     *
     * @return self
     */
    public function setApiClient(ApiClient $apiClient): self
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
    * Update $resourcePath with $
    *
    * @param string $resourcePath the resource path to use
    * @param string $baseName the base name param
    * @param string $paramName the parameter name
    *
    * @return string
    */
    public function updateResourcePath(string $resourcePath, string $baseName, string $paramName): string
    {
        return str_replace(
            "{" . $baseName . "}",
            $this->apiClient->getSerializer()->toPathValue($paramName),
            $resourcePath
        );
    }


    /**
     * Operation createWorkspace
     *
     * Create a Workspace
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\Workspace $workspace  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Workspace
     */
    public function createWorkspace($account_id, $workspace = null)
    {
        list($response) = $this->createWorkspaceWithHttpInfo($account_id, $workspace);
        return $response;
    }

    /**
     * Operation createWorkspaceWithHttpInfo
     *
     * Create a Workspace
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\Workspace $workspace  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Workspace, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWorkspaceWithHttpInfo($account_id, $workspace = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createWorkspace');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/workspaces";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($workspace)) {
            $_tempBody = $workspace;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Workspace',
                '/v2.1/accounts/{accountId}/workspaces'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Workspace', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Workspace', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createWorkspaceFile
     *
     * Creates a workspace file.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkspaceItem
     */
    public function createWorkspaceFile($account_id, $folder_id, $workspace_id)
    {
        list($response) = $this->createWorkspaceFileWithHttpInfo($account_id, $folder_id, $workspace_id);
        return $response;
    }

    /**
     * Operation createWorkspaceFileWithHttpInfo
     *
     * Creates a workspace file.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkspaceItem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWorkspaceFileWithHttpInfo($account_id, $folder_id, $workspace_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createWorkspaceFile');
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $folder_id when calling createWorkspaceFile');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling createWorkspaceFile');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "folderId", $folder_id);
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workspaceId", $workspace_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkspaceItem',
                '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkspaceItem', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkspaceItem', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkspace
     *
     * Delete Workspace
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Workspace
     */
    public function deleteWorkspace($account_id, $workspace_id)
    {
        list($response) = $this->deleteWorkspaceWithHttpInfo($account_id, $workspace_id);
        return $response;
    }

    /**
     * Operation deleteWorkspaceWithHttpInfo
     *
     * Delete Workspace
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Workspace, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWorkspaceWithHttpInfo($account_id, $workspace_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteWorkspace');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling deleteWorkspace');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workspaceId", $workspace_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Workspace',
                '/v2.1/accounts/{accountId}/workspaces/{workspaceId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Workspace', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Workspace', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkspaceFolderItems
     *
     * Deletes workspace one or more specific files/folders from the given folder or root.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     * @param \DocuSign\eSign\Model\WorkspaceItemList $workspace_item_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteWorkspaceFolderItems($account_id, $folder_id, $workspace_id, $workspace_item_list = null)
    {
        list($response) = $this->deleteWorkspaceFolderItemsWithHttpInfo($account_id, $folder_id, $workspace_id, $workspace_item_list);
        return $response;
    }

    /**
     * Operation deleteWorkspaceFolderItemsWithHttpInfo
     *
     * Deletes workspace one or more specific files/folders from the given folder or root.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     * @param \DocuSign\eSign\Model\WorkspaceItemList $workspace_item_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWorkspaceFolderItemsWithHttpInfo($account_id, $folder_id, $workspace_id, $workspace_item_list = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteWorkspaceFolderItems');
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $folder_id when calling deleteWorkspaceFolderItems');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling deleteWorkspaceFolderItems');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "folderId", $folder_id);
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workspaceId", $workspace_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($workspace_item_list)) {
            $_tempBody = $workspace_item_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkspace
     *
     * Get Workspace
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Workspace
     */
    public function getWorkspace($account_id, $workspace_id)
    {
        list($response) = $this->getWorkspaceWithHttpInfo($account_id, $workspace_id);
        return $response;
    }

    /**
     * Operation getWorkspaceWithHttpInfo
     *
     * Get Workspace
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Workspace, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWorkspaceWithHttpInfo($account_id, $workspace_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getWorkspace');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling getWorkspace');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workspaceId", $workspace_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Workspace',
                '/v2.1/accounts/{accountId}/workspaces/{workspaceId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Workspace', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Workspace', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkspaceFile
     *
     * Get Workspace File
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $file_id Specifies the room file ID GUID.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     * @param  \DocuSign\eSign\Api\WorkspacesApi\GetWorkspaceFileOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function getWorkspaceFile($account_id, $file_id, $folder_id, $workspace_id, \DocuSign\eSign\Api\WorkspacesApi\GetWorkspaceFileOptions $options = null)
    {
        list($response) = $this->getWorkspaceFileWithHttpInfo($account_id, $file_id, $folder_id, $workspace_id, $options);
        return $response;
    }

    /**
     * Operation getWorkspaceFileWithHttpInfo
     *
     * Get Workspace File
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $file_id Specifies the room file ID GUID.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     * @param  \DocuSign\eSign\Api\WorkspacesApi\GetWorkspaceFileOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWorkspaceFileWithHttpInfo($account_id, $file_id, $folder_id, $workspace_id, \DocuSign\eSign\Api\WorkspacesApi\GetWorkspaceFileOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getWorkspaceFile');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling getWorkspaceFile');
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $folder_id when calling getWorkspaceFile');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling getWorkspaceFile');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIsDownload() != 'null') {
                $queryParams['is_download'] = $this->apiClient->getSerializer()->toQueryValue($options->getIsDownload());
            }
            if ($options->getPdfVersion() != 'null') {
                $queryParams['pdf_version'] = $this->apiClient->getSerializer()->toQueryValue($options->getPdfVersion());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "fileId", $file_id);
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "folderId", $folder_id);
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workspaceId", $workspace_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listWorkspaceFilePages
     *
     * List File Pages
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $file_id Specifies the room file ID GUID.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     * @param  \DocuSign\eSign\Api\WorkspacesApi\ListWorkspaceFilePagesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PageImages
     */
    public function listWorkspaceFilePages($account_id, $file_id, $folder_id, $workspace_id, \DocuSign\eSign\Api\WorkspacesApi\ListWorkspaceFilePagesOptions $options = null)
    {
        list($response) = $this->listWorkspaceFilePagesWithHttpInfo($account_id, $file_id, $folder_id, $workspace_id, $options);
        return $response;
    }

    /**
     * Operation listWorkspaceFilePagesWithHttpInfo
     *
     * List File Pages
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $file_id Specifies the room file ID GUID.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     * @param  \DocuSign\eSign\Api\WorkspacesApi\ListWorkspaceFilePagesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PageImages, HTTP status code, HTTP response headers (array of strings)
     */
    public function listWorkspaceFilePagesWithHttpInfo($account_id, $file_id, $folder_id, $workspace_id, \DocuSign\eSign\Api\WorkspacesApi\ListWorkspaceFilePagesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listWorkspaceFilePages');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling listWorkspaceFilePages');
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $folder_id when calling listWorkspaceFilePages');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling listWorkspaceFilePages');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}/pages";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getDpi() != 'null') {
                $queryParams['dpi'] = $this->apiClient->getSerializer()->toQueryValue($options->getDpi());
            }
            if ($options->getMaxHeight() != 'null') {
                $queryParams['max_height'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxHeight());
            }
            if ($options->getMaxWidth() != 'null') {
                $queryParams['max_width'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxWidth());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "fileId", $file_id);
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "folderId", $folder_id);
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workspaceId", $workspace_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PageImages',
                '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}/pages'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PageImages', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PageImages', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listWorkspaceFolderItems
     *
     * List Workspace Folder Contents
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     * @param  \DocuSign\eSign\Api\WorkspacesApi\ListWorkspaceFolderItemsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkspaceFolderContents
     */
    public function listWorkspaceFolderItems($account_id, $folder_id, $workspace_id, \DocuSign\eSign\Api\WorkspacesApi\ListWorkspaceFolderItemsOptions $options = null)
    {
        list($response) = $this->listWorkspaceFolderItemsWithHttpInfo($account_id, $folder_id, $workspace_id, $options);
        return $response;
    }

    /**
     * Operation listWorkspaceFolderItemsWithHttpInfo
     *
     * List Workspace Folder Contents
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     * @param  \DocuSign\eSign\Api\WorkspacesApi\ListWorkspaceFolderItemsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkspaceFolderContents, HTTP status code, HTTP response headers (array of strings)
     */
    public function listWorkspaceFolderItemsWithHttpInfo($account_id, $folder_id, $workspace_id, \DocuSign\eSign\Api\WorkspacesApi\ListWorkspaceFolderItemsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listWorkspaceFolderItems');
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $folder_id when calling listWorkspaceFolderItems');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling listWorkspaceFolderItems');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getIncludeFiles() != 'null') {
                $queryParams['include_files'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeFiles());
            }
            if ($options->getIncludeSubFolders() != 'null') {
                $queryParams['include_sub_folders'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeSubFolders());
            }
            if ($options->getIncludeThumbnails() != 'null') {
                $queryParams['include_thumbnails'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeThumbnails());
            }
            if ($options->getIncludeUserDetail() != 'null') {
                $queryParams['include_user_detail'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeUserDetail());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
            if ($options->getWorkspaceUserId() != 'null') {
                $queryParams['workspace_user_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getWorkspaceUserId());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "folderId", $folder_id);
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workspaceId", $workspace_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkspaceFolderContents',
                '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkspaceFolderContents', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkspaceFolderContents', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listWorkspaces
     *
     * List Workspaces
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkspaceList
     */
    public function listWorkspaces($account_id)
    {
        list($response) = $this->listWorkspacesWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listWorkspacesWithHttpInfo
     *
     * List Workspaces
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkspaceList, HTTP status code, HTTP response headers (array of strings)
     */
    public function listWorkspacesWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listWorkspaces');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/workspaces";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkspaceList',
                '/v2.1/accounts/{accountId}/workspaces'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkspaceList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkspaceList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateWorkspace
     *
     * Update Workspace
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     * @param \DocuSign\eSign\Model\Workspace $workspace  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Workspace
     */
    public function updateWorkspace($account_id, $workspace_id, $workspace = null)
    {
        list($response) = $this->updateWorkspaceWithHttpInfo($account_id, $workspace_id, $workspace);
        return $response;
    }

    /**
     * Operation updateWorkspaceWithHttpInfo
     *
     * Update Workspace
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     * @param \DocuSign\eSign\Model\Workspace $workspace  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Workspace, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWorkspaceWithHttpInfo($account_id, $workspace_id, $workspace = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateWorkspace');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling updateWorkspace');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workspaceId", $workspace_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($workspace)) {
            $_tempBody = $workspace;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Workspace',
                '/v2.1/accounts/{accountId}/workspaces/{workspaceId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Workspace', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Workspace', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateWorkspaceFile
     *
     * Update Workspace File Metadata
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $file_id Specifies the room file ID GUID.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkspaceItem
     */
    public function updateWorkspaceFile($account_id, $file_id, $folder_id, $workspace_id)
    {
        list($response) = $this->updateWorkspaceFileWithHttpInfo($account_id, $file_id, $folder_id, $workspace_id);
        return $response;
    }

    /**
     * Operation updateWorkspaceFileWithHttpInfo
     *
     * Update Workspace File Metadata
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $file_id Specifies the room file ID GUID.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $workspace_id Specifies the workspace ID GUID.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkspaceItem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWorkspaceFileWithHttpInfo($account_id, $file_id, $folder_id, $workspace_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateWorkspaceFile');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling updateWorkspaceFile');
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $folder_id when calling updateWorkspaceFile');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling updateWorkspaceFile');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "fileId", $file_id);
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "folderId", $folder_id);
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workspaceId", $workspace_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkspaceItem',
                '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkspaceItem', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkspaceItem', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
